/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.responses;

import de.twenty11.skysail.common.responses.FailureResponse;
import de.twenty11.skysail.common.responses.SkysailResponse;
import de.twenty11.skysail.common.responses.SuccessResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class ConnectionDetailsJsonTest {
    private ObjectMapper mapper = new ObjectMapper();
    private SkysailResponse<List<ConnectionDetails>> failureResponse;
    private SkysailResponse<List<ConnectionDetails>> successResponse;

    @Before
    public void setUp() throws Exception {
        this.failureResponse = new FailureResponse();
        this.failureResponse.setMessage("error");
        this.successResponse = new SuccessResponse();
        this.successResponse.setMessage("mymsg");
        ArrayList<ConnectionDetails> mydata = new ArrayList<ConnectionDetails>();
        mydata.add(new ConnectionDetails("path", "username", "password", "url", "driverClassName"));
        this.successResponse.setData(mydata);
    }

    @Test
    public void testSerializationOfFailureResponse() throws JsonGenerationException, JsonMappingException, IOException {
        String strRep = this.asJson(this.failureResponse);
        MatcherAssert.assertThat((Object)strRep, (Matcher)Matchers.containsString((String)"\"success\":false"));
        MatcherAssert.assertThat((Object)strRep, (Matcher)Matchers.containsString((String)"\"message\":\"error\""));
    }

    @Test
    public void testSerializationOfSuccessResponse() throws JsonGenerationException, JsonMappingException, IOException {
        String strRep = this.asJson(this.successResponse);
        MatcherAssert.assertThat((Object)strRep, (Matcher)Matchers.containsString((String)"\"success\":true"));
        MatcherAssert.assertThat((Object)strRep, (Matcher)Matchers.containsString((String)"\"message\":\"mymsg\""));
    }

    @Test
    public void testDeserializationOfSuccessResponse() throws Exception {
        String strRep = this.mapper.writeValueAsString(this.successResponse);
        System.out.println(strRep);
    }

    public String asJson(SkysailResponse<List<ConnectionDetails>> successResponse) throws JsonGenerationException, JsonMappingException, IOException {
        return this.mapper.writeValueAsString(successResponse);
    }

    private class ConnectionDetails
    implements Serializable {
        private static final long serialVersionUID = -1079406626730388016L;
        public static final String NAME = "path";
        public static final String USERNAME = "username";
        public static final String PASSWORD = "password";
        public static final String DRIVERNAME = "drivername";
        public static final String URL = "url";
        @JsonIgnore
        private int pid;
        @NotNull(message="Name is mandatory")
        @Size(min=1, message="Name must not be empty")
        private String name;
        private String username;
        private String password;
        private String driverName;
        private String url;

        public int getPid() {
            return this.pid;
        }

        public ConnectionDetails() {
        }

        @JsonCreator
        public ConnectionDetails(@JsonProperty(value="username") String name, @JsonProperty(value="password") String username, @JsonProperty(value="url") String password, @JsonProperty(value="driverClassName") String url, String driverClassName) {
            this.name = name;
            this.username = username;
            this.password = password;
            this.url = url;
            this.driverName = driverClassName;
        }

        public String getName() {
            return this.name;
        }

        @NotNull(message="field 'username' is mandatory")
        @Size(min=1)
        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        @NotNull(message="field 'drivername' is mandatory")
        public String getDriverName() {
            return this.driverName;
        }

        @NotNull(message="field 'url' is mandatory")
        public String getUrl() {
            return this.url;
        }

        public Map<String, String> toMap() {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(NAME, this.name);
            result.put(USERNAME, this.username);
            result.put(PASSWORD, this.password);
            result.put(URL, this.url);
            result.put(DRIVERNAME, this.driverName);
            return result;
        }
    }
}

