package de.twenty11.skysail.common.testing.utils;

import static org.ops4j.pax.exam.CoreOptions.equinox;
import static org.ops4j.pax.exam.CoreOptions.mavenBundle;
import static org.ops4j.pax.exam.CoreOptions.systemProperty;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;

import org.ops4j.pax.exam.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This class defines the bundles (to be used by pax exam) skysail.common depends on.
 * 
 * Other XXXOsgiSetup classes can extend
 * 
 * @author carsten
 * 
 */
public class SkysailCommonOsgiSetup extends AbstractFrameworkIntegrationSetup {

    private static Logger logger = LoggerFactory.getLogger(SkysailCommonOsgiSetup.class.getName());

    @Override
    public List<Option> getOptions(EnumSet<PaxExamOptionSet> optionSets) {

        List<Option> options = super.getOptions(optionSets);

        // needed for skysail.common (dependency)
        options.add(mavenBundle("commons-lang", "commons-lang", "2.6"));
        options.add(mavenBundle("log4j", "log4j", "1.2.17"));

        // options.add(mavenBundle("org.mockito", "mockito-all", "1.9.5"));

        // http://team.ops4j.org/wiki/display/paxurl/Mvn+Protocol#MvnProtocol-configuration
        options.add(systemProperty("org.ops4j.pax.url.mvn.repositories")
                .value("https://oss.sonatype.org/content/groups/public,https://repository.apache.org/content/repositories/releases,http://download.eclipse.org/rt/eclipselink/maven.repo"));
        // felix().version("3.2.2")
        options.add(equinox().version("3.6.2"));

        logger.info("using options from {} for tests", this.getClass());

        return options;
    }

    public void logOptionsUsed(Option[] options2Use) {
        for (Option option : options2Use) {
            logger.info(option.toString());
        }
    }

    public String getProjectVersion() {
        Properties props = new Properties();
        Reader fileReader = null;
        try {
            fileReader = new FileReader("project.properties");
            props.load(fileReader);
            return props.getProperty("project.version.from.pom");
        } catch (Exception e) {
            try {
                props.load(new FileReader("target/classes/project.properties"));
                return props.getProperty("project.version.from.pom");
            } catch (Exception e1) {
                e1.printStackTrace();
                return "unknownVersion";
            }
        } finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                } catch (IOException e) {
                    // cannot do anything
                }
            }
        }
    }

}
