package de.twenty11.skysail.common.testing.utils;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiUtils {

    private static Logger logger = LoggerFactory.getLogger(OsgiUtils.class.getName());

    public Bundle getBundleByName(BundleContext context, String symbolicName) {
        Bundle[] bundles = context.getBundles();
        for (Bundle bundle : bundles) {
            if (bundle.getSymbolicName().equals(symbolicName)) {
                return bundle;
            }
        }
        return null;
    }

    public Bundle logBundleInfo(BundleContext context) {
        Bundle[] bundles = context.getBundles();
        for (Bundle bundle : bundles) {
            logger.info("{} ({}) is in state {}",
                    new Object[] { bundle.getSymbolicName(), bundle.getVersion(), bundle.getState() });
        }
        return null;
    }

    public Object getService(BundleContext context, String clazz) {
        ServiceReference serviceReference = context.getServiceReference(clazz);
        if (serviceReference == null) {
            logger.warn("could not find service reference for {}", clazz);
            logger.info("found the following service references:");
            try {
                ServiceReference[] allServiceReferences = context.getAllServiceReferences(null, null);
                for (ServiceReference sr : allServiceReferences) {
                    logger.info(sr.toString());
                }
            } catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
        }
        return context.getService(serviceReference);
    }

}
