package de.twenty11.skysail.common.testing.utils;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiTestingUtils {

    private static Logger logger = LoggerFactory.getLogger(OsgiTestingUtils.class.getName());

    public static Bundle getBundleForSymbolicName(BundleContext context, String symbolicName) {
        logger.info("testing existence of bundle with symbolic name '{}'", symbolicName);
        Bundle myBundle = null;
        Bundle[] bundles = context.getBundles();
        for (Bundle bundle : bundles) {
            if (bundle.getSymbolicName().equals(symbolicName)) {
                myBundle = bundle;
            }
        }
        return myBundle;
    }

    public static void dumpBundleInfo(BundleContext context) {
        Bundle[] bundles = context.getBundles();
        for (Bundle bundle : bundles) {
            System.out.println(bundle.getState() + ": " + bundle.getSymbolicName());
        }
    }

    public static void dumpServicesInfo(BundleContext context) {
        ServiceReference[] serviceReferences;
        try {
            serviceReferences = context.getAllServiceReferences(null, null);
            for (ServiceReference sr : serviceReferences) {
                System.out.println(sr.toString());
            }
        } catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

}
