package de.twenty11.skysail.common.selfdescription;

import java.util.HashMap;
import java.util.Map;

import de.twenty11.skysail.common.Presentable;
import de.twenty11.skysail.common.PresentableHeader;

/**
 * A skysail server resource provides information about its capabilities by exposing
 * a list of ResourceDetails.
 *
 */
public class ResourceDetails implements Presentable {
    
    private String path;
    private String finder;
    private String desc;
    private String text;

    public ResourceDetails(String path, String text, String finder, String desc) {
        this.path = path;
        this.text = text;
        this.finder = finder;
        this.desc = desc;
    }
    
    public String getPath() {
        return path;
    }
    
    public String getFinder() {
        return finder;
    }
    
    public String getDesc() {
        return desc;
    }

    public String getText() {
        return text;
    }

    @Override
    public PresentableHeader getHeader() {
        return new PresentableHeader.Builder(text).setLink(path).setImage("icon-list-alt").build();
    }

    @Override
    public Map<String, Object> getContent() {
        Map<String, Object> result = new HashMap<String, Object>();
        result.put("Finder", finder);
        result.put("Description", desc);
        return result;
    }

}
