package de.twenty11.skysail.common.responses;

/**
 * A last type of Response is the FormResponse: You'd get it in case of an HTML - Request whenever you want to add an
 * entity or to display an existing one which you'd want to change.
 */
public class FormResponse<T> extends SkysailResponse<T> {

    private String target;

    public FormResponse(T entity) {
        super(entity);
        this.target = ".";
        setMessage("web form");
    }

    public FormResponse(T entity, String target) {
        super(entity);
        this.target = target;
        setMessage("web form");
    }

    public String getTarget() {
        return target;
    }

}
