package de.twenty11.skysail.common.responses;

import java.util.Set;

import javax.validation.ConstraintViolation;

/**
 * Being a "business server", skysail has to deal with business requirements such as constraints (e.g. the field name
 * may not be empty). So when a user requests to add an entity which does not comply with the business rules, you should
 * not create a FailureResponse, but a ConstraintViolationResponse, containing information about the cause and the
 * rules. Skysail utilizes the javax.validation interfaces for this purpose.
 */
public class ConstraintViolationsResponse<T> extends SkysailResponse<T> {

    private Set<ConstraintViolation<T>> violations;

    public ConstraintViolationsResponse(T entity, Set<ConstraintViolation<T>> violations) {
        super();
        setSuccess(false);
        setData(entity);
        this.violations = violations;
    }

    public Set<ConstraintViolation<T>> getViolations() {
        return violations;
    }
}
