package de.twenty11.skysail.common.graphs;

import java.util.List;
import java.util.Map;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@JsonDeserialize(as=DefaultNodeProvider.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public interface NodeProvider {
    
    String getType();

    String getNodeId();
    
    String getNodeLabel();
    
    Map<String,String> getNodeProperties();
    
    List<EdgeProvider> getEdges();

}
