package de.twenty11.skysail.common.graphs;

import java.util.Map;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@JsonDeserialize(as = DefaultEdgeProvider.class)
@JsonIgnoreProperties(ignoreUnknown = true)
public interface EdgeProvider {

    String getEdgeId();

    String getEdgeLabel();

    String getSource();

    String getTarget();

    int getWeight();

    Map<String, String> getEdgeProperties();

}
