package de.twenty11.skysail.common.forms;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target({ ElementType.FIELD, ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Field {

    Class<? extends IndexProvider> indexProvider() default IgnoreIndexProvider.class;

    Class<? extends ValuesProvider> valuesProvider() default IgnoreValuesProvider.class;

    String[] tags() default { "all" };
}
