package de.twenty11.skysail.common;

import java.util.Map;

import org.codehaus.jackson.annotate.JsonIgnore;

/**
 * An Interface to be implemented by Classes like XYZDetails or -Descriptor which describe Resources.
 * 
 * The information from this interface is used in {@link Json2BootstrapConverter}.
 * 
 */
public interface Presentable {

    /**
     * http://twitter.github.com/bootstrap/base-css.html#icons
     * 
     * @return name of icon
     */
    @JsonIgnore
    PresentableHeader getHeader();

    /**
     * Return a LinkedHashMap if you care about keeping the order of insertion
     * 
     * @return
     */
    @JsonIgnore
    Map<String, Object> getContent();

}
