package de.twenty11.skysail.common;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.codehaus.jackson.annotate.JsonIgnore;

public class AbstractPresentable implements Presentable {

    private Object instanceToInspect = null;

    @Override
    @JsonIgnore
    public PresentableHeader getHeader() {
        if (instanceToInspect == null) {
            throw new IllegalStateException("must set instanceToInspect before calling getHeader");
        }
        List<Method> getters = getGetters(instanceToInspect.getClass());
        for (Method method : getters) {
            if (method.getName().equals("getName")) {
                return invokeForHeader(method);
            } else if (method.getName().equals("getId")) {
                return invokeForHeader(method);
            }
        }
        return new PresentableHeader.Builder(this.toString()).build();
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getContent() {
        Map<String, Object> result = new HashMap<String, Object>();
        List<Method> getters = getGetters(instanceToInspect.getClass());
        for (Method method : getters) {
            try {
                result.put(method.getName().substring(3), method.invoke(instanceToInspect, new Object[0]));
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
        return result;
    }

    private List<Method> getGetters(Class<?> cls) {
        List<Method> results = new ArrayList<Method>();
        Method[] methods = cls.getMethods();
        for (Method method : methods) {
            if (method.getName().startsWith("get") && method.getReturnType().equals(String.class)) {
                if (method.getParameterTypes().length == 0) {
                    results.add(method);
                }
            }
        }
        return results;
    }

    private PresentableHeader invokeForHeader(Method method) {
        String name;
        try {
            name = (String) method.invoke(instanceToInspect, new Object[0]);
            return new PresentableHeader.Builder(name).build();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setInstanceToInspect(Object instanceToInspect) {
        this.instanceToInspect = instanceToInspect;
    }

}
