/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.navigation;

import de.twenty11.skysail.common.navigation.Navigation;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.restlet.Request;
import org.restlet.data.Reference;

public class NavigationTest {
    private Set<String> mappings;
    private Request request;

    @Before
    public void createNavigation() throws Exception {
        this.request = (Request)Mockito.mock(Request.class);
        this.mappings = new TreeSet<String>();
    }

    @Test
    public void doesnot_mind_about_null_parameters() {
        new Navigation(null, null);
    }

    @Test
    public void returns_null_for_homeLink_if_not_in_mappings() {
        Navigation navigation = new Navigation(this.request, Collections.emptySet());
        Assert.assertThat((Object)navigation.getHome(), (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
    }

    @Test
    public void returns_homeLink_if_in_mappings() {
        Reference reference = (Reference)Mockito.mock(Reference.class);
        Mockito.when((Object)reference.toString()).thenReturn((Object)"link");
        Mockito.when((Object)this.request.getRootRef()).thenReturn((Object)reference);
        Navigation navigation = new Navigation(this.request, this.mappings);
        Assert.assertThat((Object)navigation.getHome(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"link")));
    }

    @Test
    public void returns_null_for_backLink_if_no_referrer_was_found() {
        Navigation navigation = new Navigation(this.request, this.mappings);
        String back = navigation.getBack();
        Assert.assertThat((Object)back, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void returns_backLink_if_referrer_was_found() {
        Reference reference = new Reference("backReference");
        Mockito.when((Object)this.request.getReferrerRef()).thenReturn((Object)reference);
        Navigation navigation = new Navigation(this.request, this.mappings);
        String back = navigation.getBack();
        Assert.assertThat((Object)back, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"backReference")));
    }
}

