/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.grids;

import de.twenty11.skysail.common.grids.ColumnDefinition;
import de.twenty11.skysail.common.grids.Columns;
import de.twenty11.skysail.common.grids.ColumnsBuilder;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ColumnsTest {
    private Columns columns;
    private static final String COL2 = "col2";
    private static final String COL1 = "col1";
    private ObjectMapper mapper = new ObjectMapper();

    @Before
    public void setUp() throws Exception {
        ColumnsBuilder builder = new ColumnsBuilder(){

            public void configure() {
                this.addColumn(ColumnsTest.COL1).setSorting(Integer.valueOf(2));
                this.addColumn(ColumnsTest.COL2).setSorting(Integer.valueOf(1));
            }
        };
        this.columns = new Columns(builder);
    }

    @Test
    public void testConstructor() {
        Assert.assertEquals((long)2L, (long)this.columns.getAsList().size());
        Assert.assertEquals((Object)COL1, (Object)this.columns.getColumnName(Integer.valueOf(0)));
        Assert.assertEquals((Object)COL2, (Object)this.columns.getColumnName(Integer.valueOf(1)));
        Assert.assertEquals((Object)0, (Object)this.columns.getColumnId(COL1));
        Assert.assertEquals((Object)1, (Object)this.columns.getColumnId(COL2));
    }

    @Test
    public void testGetAsList() {
        List asList = this.columns.getAsList();
        Assert.assertEquals((long)2L, (long)asList.size());
    }

    @Test
    public void testGetColumnsInSortOrder() {
        List sortedColumns = this.columns.getColumnsInSortOrder();
        Assert.assertEquals((Object)COL2, (Object)((ColumnDefinition)sortedColumns.get(0)).getName());
        Assert.assertEquals((Object)COL1, (Object)((ColumnDefinition)sortedColumns.get(1)).getName());
    }

    @Test
    public void testGetMaxSortValueFromBuilder() {
        Assert.assertEquals((long)2L, (long)this.columns.getMaxSortValueFromBuilder());
    }

    @Test
    public void testGetSortingRepresentation() {
        Assert.assertEquals(null, (Object)this.columns.getSortingRepresentation());
    }

    @Test
    public void simpleSerialize() throws Exception {
        String strRep = this.mapper.writeValueAsString((Object)this.columns);
        Assert.assertTrue((boolean)strRep.contains("{\"name\":\"col1\",\"width\":null,\"sorting\":2,\"filterValue\":\"\""));
    }

    @Test
    public void seserializeAndDeserialize() throws Exception {
        String serialized = this.mapper.writeValueAsString((Object)this.columns);
        Columns deserializedPayload = (Columns)this.mapper.readValue(serialized, Columns.class);
        Assert.assertTrue((boolean)this.columns.equals((Object)deserializedPayload));
    }
}

