/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.converter.test;

import de.twenty11.skysail.common.converter.Json2HtmlConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class Json2HtmlConverterTest {
    private Json2HtmlConverter converter;

    @Before
    public void setUp() throws Exception {
        this.converter = new Json2HtmlConverter("name");
    }

    @Test
    @Ignore
    public void convertMinimal() {
        String json = "{}";
        String html = this.converter.jsonToHtml(json, null);
        String[] lines = html.split("\\n");
        Assert.assertThat((Object)lines[0], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"<div id=\"json\">")));
        Assert.assertThat((Object)lines[1], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"{")));
        Assert.assertThat((Object)lines[2], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"  <ul class=\"obj collapsible\">")));
        Assert.assertThat((Object)lines[3], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"  </ul>")));
        Assert.assertThat((Object)lines[4], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"}")));
        Assert.assertThat((Object)lines[5], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"</div>")));
    }

    @Test
    @Ignore
    public void convertAString() {
        String json = "{\"a\" : \"b\"}";
        String html = this.converter.jsonToHtml(json, null);
        System.out.println(html);
    }

    @Test
    @Ignore
    public void convertAString2() {
        String json = "{\"a\" : \"b\", \"success\" : true, \"anarray\":[1,2,\"text\"]}";
        String html = this.converter.jsonToHtml(json, null);
        System.out.println(html);
    }

    @Test
    @Ignore
    public void convertAnArray() {
        String json = "{\"anarray\" : [1,2,\"thr<h1>ee\"]}";
        String html = this.converter.jsonToHtml(json, null);
        String[] lines = html.split("\\n");
        int i = 3;
        Assert.assertThat((Object)lines[i++], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"    <li>")));
        Assert.assertThat((Object)lines[i++], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"      <div class=\"collapser\">-</div>")));
        Assert.assertThat((Object)lines[i++], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"      <span class=\"prop\">")));
        Assert.assertThat((Object)lines[i++], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"        <span class=\"q\">\"</span>anarray<span class=\"q\">\"</span>")));
        Assert.assertThat((Object)lines[i++], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"      </span>: [")));
        Assert.assertThat((Object)lines[i++], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"      <ul class=\"array collapsible\">")));
        Assert.assertThat((Object)lines[i++], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"        <li><span class=\"num\">1</span>,</li>")));
        Assert.assertThat((Object)lines[i++], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"        <li><span class=\"num\">2</span>,</li>")));
        Assert.assertThat((Object)lines[i++], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"        <li><span class=\"string\">\"thr<h1>ee\"</span></li>")));
        Assert.assertThat((Object)lines[i++], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"      </ul>")));
        Assert.assertThat((Object)lines[i++], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"      ]")));
        Assert.assertThat((Object)lines[i++], (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"    </li>")));
    }

    @Test
    @Ignore
    public void convertExample() {
        String json = "{\"hey\":\"guy\",\"anumber\":243,\"anobject\":{\"whoa\":\"nuts\",\"anarray\":[1,2,\"thr<h1>ee\"],\"more\":\"stuff\"},\"awesome\":true,\"bogus\":false,\"meaning\":null,\"japanese\":\"\",\"link\":\"http://jsonview.com\", \"notLink\": \"http://jsonview.com is great\",\"aZero\":0,\"emptyString\":\"\"}";
        String html = this.converter.jsonToHtml(json, null);
        String[] lines = html.split("\\n");
        int i = 3;
    }

    private String readJsonFile(String file) throws Exception {
        String sCurrentLine;
        File jsonFile = new File("src/test/resources/jsonExamples/" + file);
        FileReader fileReader = new FileReader(jsonFile);
        BufferedReader in = new BufferedReader(fileReader);
        StringBuffer json = new StringBuffer();
        while ((sCurrentLine = in.readLine()) != null) {
            json.append(sCurrentLine);
        }
        return json.toString();
    }
}

