/**
 *  Copyright 2011 Carsten Gräf
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */

package de.twenty11.skysail.common.app;

/**
 * Holder for a name, a description and the context path. Immutable.
 *
 * TODO find better name
 * 
 * @author carsten
 * 
 */
public final class ApplicationDescription {

	/** Name of the application. */
	private final String name;

	/** a description. */
	private final String description;

	/** the context path. */
	private final String rootContextPath;

	/**
	 * Constructor.
	 * 
	 * @param appName
	 *            name of the application
	 * @param desc
	 *            description
	 * @param path
	 *            context path
	 */
	public ApplicationDescription(String appName, String desc, String path) {
		this.name = appName;
		this.description = desc;
		this.rootContextPath = path;
	}

	public String getName() {
		return name;
	}

	public String getDescription() {
		return description;
	}

	public String getRootContextPath() {
		return rootContextPath;
	}

	@Override
	public String toString() {
		return new StringBuffer("ApplicationDescription [").append(name).append(rootContextPath).append("]").toString();
	}

}
