/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.utils;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiUtils {
    private static Logger logger = LoggerFactory.getLogger((String)OsgiUtils.class.getName());

    public Bundle getBundleByName(BundleContext context, String symbolicName) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = context.getBundles()) {
            if (!bundle.getSymbolicName().equals(symbolicName)) continue;
            return bundle;
        }
        return null;
    }

    public Bundle logBundleInfo(BundleContext context) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = context.getBundles()) {
            logger.info("{} ({}) is in state {}", new Object[]{bundle.getSymbolicName(), bundle.getVersion(), bundle.getState()});
        }
        return null;
    }

    public Object getService(BundleContext context, String clazz) {
        ServiceReference serviceReference = context.getServiceReference(clazz);
        if (serviceReference == null) {
            logger.warn("could not find service reference for {}", (Object)clazz);
            logger.info("found the following service references:");
            try {
                ServiceReference[] allServiceReferences;
                for (ServiceReference sr : allServiceReferences = context.getAllServiceReferences(null, null)) {
                    logger.info(sr.toString());
                }
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
        }
        return context.getService(serviceReference);
    }
}

