/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.navigation;

import java.util.Set;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.restlet.Request;
import org.restlet.data.Reference;

public class Navigation {
    private String home;
    @JsonIgnore
    private Request restletRequest;
    private String back;
    private String up;
    private Set<String> mappings;

    public Navigation() {
    }

    public Navigation(Request request, Set<String> mappings) {
        this.restletRequest = request;
        this.mappings = mappings;
        if (request != null) {
            if (request.getRootRef() != null) {
                this.home = this.shortestMapping(request.getRootRef().toString(), mappings);
            }
            this.up = this.calcUpReference(request.getOriginalRef(), request.getRootRef(), mappings);
            this.back = request.getReferrerRef() != null ? request.getReferrerRef().toString() : null;
        }
    }

    private String shortestMapping(String root, Set<String> mappings) {
        String result = "";
        int length = Integer.MAX_VALUE;
        for (String mapping : mappings) {
            if (mapping.length() >= length) continue;
            result = mapping;
            length = mapping.length();
        }
        return root + result;
    }

    private String calcUpReference(Reference reference, Reference rootRef, Set<String> mappings) {
        String result = null;
        if (rootRef == null) {
            return null;
        }
        if (reference != null && reference.getParentRef() != null) {
            String upCandidate = reference.getParentRef().toString();
            if (this.inMappings(mappings, rootRef, upCandidate)) {
                result = upCandidate;
            } else {
                if (reference.toString().equals(reference.getParentRef().toString())) {
                    return null;
                }
                return this.calcUpReference(reference.getParentRef(), rootRef, mappings);
            }
        }
        return result;
    }

    private boolean inMappings(Set<String> mappings, Reference rootRef2, String upCandidate) {
        if (mappings == null || rootRef2 == null || upCandidate == null) {
            return false;
        }
        for (String path : mappings) {
            if (!upCandidate.equals(rootRef2.toString() + path)) continue;
            return true;
        }
        return false;
    }

    public String getBack() {
        return this.back;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getHome() {
        return this.home;
    }

    public String getUp() {
        return this.up;
    }
}

