/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.forms;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import de.twenty11.skysail.common.SkysailData;
import de.twenty11.skysail.common.forms.FieldDefinition;
import de.twenty11.skysail.common.forms.FormBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;

public class FormData
implements SkysailData {
    private static final long serialVersionUID = 4534925071257754501L;
    private Map<String, FieldDefinition> fields;
    @JsonIgnore
    @XStreamOmitField
    private FormBuilder formBuilder;

    public FormData(FormBuilder formBuilder) {
        this.formBuilder = formBuilder;
        this.fields = this.getFormFromBuilder();
    }

    @Override
    public int getSize() {
        return 1;
    }

    public Map<String, FieldDefinition> getFields() {
        return new HashMap<String, FieldDefinition>(this.fields);
    }

    @JsonIgnore
    private Map<String, FieldDefinition> getFormFromBuilder() {
        if (this.formBuilder != null) {
            return this.formBuilder.getColumns();
        }
        return Collections.emptyMap();
    }

    public void set(String key, String value) {
        if (!this.fields.keySet().contains(key)) {
            throw new IllegalArgumentException("key '" + key + "' does not exist as field name in Form");
        }
        this.fields.get(key).setValue(value);
    }
}

