/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.forms;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import de.twenty11.skysail.common.forms.FieldType;
import de.twenty11.skysail.common.forms.FormBuilder;
import java.io.Serializable;
import java.util.logging.Logger;
import org.codehaus.jackson.annotate.JsonIgnore;

public class FieldDefinition
implements Serializable {
    private static final long serialVersionUID = 6627992829570047981L;
    private String name;
    private FieldType type;
    @XStreamOmitField
    @JsonIgnore
    private transient FormBuilder builder;
    private String value;
    private static Logger logger = Logger.getLogger(FieldDefinition.class.getName());

    public FieldDefinition(String fieldName, FieldType fieldType, FormBuilder formBuilder) {
        this.name = fieldName;
        this.type = fieldType;
        this.builder = formBuilder;
    }

    public final FieldDefinition addField(String fieldName, FieldType fieldType) {
        if (this.builder == null) {
            logger.warning("Field being added to fieldDefinition without a FieldBuilder available!");
            return null;
        }
        FieldDefinition addedField = this.builder.addField(fieldName, fieldType);
        return addedField;
    }

    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return "<input type='text' value='" + this.value + "'>";
    }

    public void setValue(String provided) {
        this.value = provided;
    }

    public String getValue() {
        return this.value;
    }
}

