package de.twenty11.skysail.common.utils;

import java.util.List;

import org.restlet.engine.Engine;
import org.restlet.engine.converter.ConverterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

// TODO move to skysail.client.common?
public class RestletUtils {
    
    private static final Logger logger = LoggerFactory.getLogger(RestletUtils.class);

    public static void replaceConverter(Class<? extends ConverterHelper> converterClass, ConverterHelper newConverter) {

        List<ConverterHelper> converters = Engine.getInstance().getRegisteredConverters();
        boolean found = false;
        for (int i = 0; i < converters.size(); i++) {
            if (converters.get(i).getClass().equals(converterClass)) {
                logger.info("replacing converter {} with {}", converterClass, newConverter);
                converters.set(i, newConverter);
                found = true;
                break;
            }
            if (converters.get(i).getClass().equals(MyLocalJacksonCustomConverter.class)) {
                logger.info("replacing converter {} with {}", converters.get(i), newConverter);
                converters.set(i, newConverter);
                found = true;
                break;
            }
        }
        if (!found) {
            logger.info("adding converter {} ", newConverter);
            converters.add(newConverter);
        }

    }

}
