/**
 *  Copyright 2011 Carsten Gräf
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */

package de.twenty11.skysail.common.responses;

import java.util.Set;

import org.restlet.Request;

/**
 * Message to be send back to the client in case of success.
 * 
 * @author carsten
 * 
 * @param <T>
 */
public class SuccessResponse<T> extends Response<T> {

    /**
     * empty constructor.
     * 
     * Needed for reflection.
     */
    public SuccessResponse() {
    }

    public SuccessResponse(T data) {
        super(data);
    }

    public SuccessResponse(T data, Request request, Set<String> mappings) {
        super(data, request, mappings);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Success: ").append(getSuccess()).append(", Message: ").append(getMessage());
        return sb.toString();
    }
}
