package de.twenty11.skysail.common.navigation;

import java.util.Set;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.restlet.Request;
import org.restlet.data.Reference;

/**
 * Providing means of navigation is a secondary responsibility of skysail, i.e. skysail will try to gather related
 * information but will not complain if it is not available or determinable.
 * 
 */
public class Navigation {

    private String home;

    @JsonIgnore
    private Request restletRequest;

    private String back;

    private String up;

    private Set<String> mappings;

    public Navigation() {
    }

    public Navigation(Request request, Set<String> mappings) {
        this.restletRequest = request;
        this.mappings = mappings;
        if (request != null) {
            // String defaultQueryToAttach = getDefaultQuery(request);
            if (request.getRootRef() != null) {
                home = shortestMapping(request.getRootRef().toString(), mappings);
            }
            up = calcUpReference(request.getOriginalRef(), request.getRootRef(), mappings);
            back = request.getReferrerRef() != null ? request.getReferrerRef().toString() : null;
        }
    }

    private String shortestMapping(String root, Set<String> mappings) {
        String result = "";
        int length = Integer.MAX_VALUE;
        for (String mapping : mappings) {
            if (mapping.length() < length) {
                result = mapping;
                length = mapping.length();
            }
        }
        return root + result;
    }

    private String calcUpReference(Reference reference, Reference rootRef, Set<String> mappings) {
        String result = null;
        if (rootRef == null) {
            return null;
        }
        if (reference != null && reference.getParentRef() != null) {
            String upCandidate = reference.getParentRef().toString();
            if (inMappings(mappings, rootRef, upCandidate)) {
                result = upCandidate;// + defaultQueryToAttach;
            } else {
                if (reference.toString().equals(reference.getParentRef().toString())) {
                    return null;
                }
                return calcUpReference(reference.getParentRef(), rootRef, mappings);
            }
        }
        return result;
    }

    private boolean inMappings(Set<String> mappings, Reference rootRef2, String upCandidate) {
        if (mappings == null || rootRef2 == null || upCandidate == null) {
            return false;
        }
        for (String path : mappings) {
            if (upCandidate.equals(rootRef2.toString() + path)) {
                return true;
            }
        }
        return false;
    }

    public String getBack() {
        return back;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getHome() {
        return home;
    }

    public String getUp() {
        return up;
    }

}
