/**
 *  Copyright 2011 Carsten Gräf
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */

package de.twenty11.skysail.common.grids;

import java.io.Serializable;
import java.util.Comparator;

/**
 * must be "consistent with equals", see treeMap javadoc.
 * 
 * moved from internal package due to call in {@link GridDataServerResource}
 * 
 * @author carsten
 * 
 */
public class ColumnSortOrderComparator implements Comparator<ColumnDefinition>,
		Serializable {

	/**
	 * implements Serializable.
	 */
	private static final long serialVersionUID = 9112648222241321210L;

	/** 
	 * sorts the columnDefinitions according to their absolute sorting value.
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	@Override
	public int compare(ColumnDefinition colA, ColumnDefinition colB) {
		if (colA == null && colB == null) {
			return -1;
		} else if (colB == null) {
			return 1;
		} else if (colA == null) {
			return -1;
		}

		Integer sortingA = colA.getSorting();
		Integer sortingB = colB.getSorting();

		if (sortingA == null && sortingB == null) {
			return -1;
		} else if (sortingB == null) {
			return 1;
		} else if (sortingA == null) {
			return -1;
		} else {
			return Integer.valueOf(Math.abs(sortingA)).compareTo(
					Math.abs(sortingB));
		}
	}
}
