/**
 *  Copyright 2011 Carsten Gräf
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */

package de.twenty11.skysail.common.forms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.codehaus.jackson.annotate.JsonIgnore;

import com.thoughtworks.xstream.annotations.XStreamOmitField;

import de.twenty11.skysail.common.SkysailData;

/**
 * A data structure supporting html forms implementing the interface {@link SkysailData}.
 * 
 * @author carsten
 * 
 */
public class FormData implements SkysailData {

    /** serial number. */
    private static final long serialVersionUID = 4534925071257754501L;

    /** payload of FormData. */
    private Map<String, FieldDefinition> fields;
    
    @JsonIgnore
    @XStreamOmitField
    private FormBuilder formBuilder;

    
    // TODO check the same approach with GridData (immutable through constructor)
    public FormData (FormBuilder formBuilder) {
        this.formBuilder = formBuilder;
        fields = getFormFromBuilder();
    }

    @Override
    public int getSize() {
        return 1;
    }
    
    public Map<String, FieldDefinition> getFields() {
        return new HashMap<String, FieldDefinition>(fields);
    }

    /**
     * @return
     */
    @JsonIgnore
    private Map<String, FieldDefinition> getFormFromBuilder() {
        if (this.formBuilder != null) {
            return this.formBuilder.getColumns();
        }
        return Collections.emptyMap();
    }

    public void set(String key, String value) {
        if (!fields.keySet().contains(key)) {
            throw new IllegalArgumentException("key '" + key + "' does not exist as field name in Form");
        }
        fields.get(key).setValue(value);
    }

}
