package de.twenty11.skysail.common.forms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.validation.ConstraintViolation;

import org.codehaus.jackson.annotate.JsonIgnore;

public class ConstraintViolations<T> {

    //@JsonIgnore
    List<Violation> violations = new ArrayList<Violation>();

    public ConstraintViolations() {
        // for jackson
    }
    
    public ConstraintViolations(Set<ConstraintViolation<T>> contraintViolations) {
        for (ConstraintViolation<T> violation : contraintViolations) {
            violations.add(new Violation(violation.getMessage()));
        }
    }
    
    public void setViolations(List<Violation> violations) {
        this.violations = violations;
    }
    
    public List<Violation> getViolations() {
        return violations;
    }
    
    public int size() {
        return violations.size();
    }
    
    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(size() + " violation(s):\n");
        for (Violation violation : violations) {
            sb.append(" - ").append(violation.getMessage()).append("\n");
        }
        return sb.toString();
    }
}
