/**
 *  Copyright 2011 Carsten Gräf
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * 
 */

package de.twenty11.skysail.common;

import java.io.Serializable;

/**
 * A class implementing this interface can be used in the skysail server-client communication, i.e. in
 * {@link SkysailResponse}s.
 * 
 * The key feature of a data structure is to serve as a container holding elements of the same kind, and there are
 * "getSize" elements of the "same kind".
 * 
 * 
 */
public interface SkysailData extends Serializable {

    /**
     * @return the number of data elements in this data structure
     */
    int getSize();

}
