/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.ext.osgimonitor.test;

import de.twenty11.skysail.common.ext.osgimonitor.HeaderDescriptor;
import java.util.Dictionary;
import java.util.Hashtable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;

public class HeaderDescriptorTest {
    private HeaderDescriptor headerDescriptor;
    private Bundle bundle;
    private Dictionary headers;

    @Before
    public void setUp() {
        this.bundle = (Bundle)Mockito.mock(Bundle.class);
        this.headers = new Hashtable();
        Mockito.when((Object)this.bundle.getHeaders()).thenReturn((Object)this.headers);
    }

    @Test
    public void test_parsing_of_simpleDescription() {
        this.setExportPackageString("org.codehaus.jackson.schema;uses:=\"org.codehaus.jackson.node\";version=\"1.9.8\"");
        this.headerDescriptor = new HeaderDescriptor(this.bundle);
        Assert.assertThat((Object)((String)this.headerDescriptor.getContent().get("Export-Package")), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"org.codehaus.jackson.schema;version=\"1.9.8\"<br>\n")));
    }

    @Test
    public void test_parsing_of_description_with_two_packages() {
        this.setExportPackageString("org;uses:=\"com\";version=\"1.9\",de;version=\"2\"");
        this.headerDescriptor = new HeaderDescriptor(this.bundle);
        Assert.assertThat((Object)((String)this.headerDescriptor.getContent().get("Export-Package")), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"org;version=\"1.9\",<br>\nde;version=\"2\"<br>\n")));
    }

    private void setExportPackageString(String desc) {
        this.headers.put("Export-Package", desc);
    }
}

