package de.twenty11.skysail.common.ext.osgimonitor.internal;


public enum States implements State {
    PACKAGE {
        public boolean process(ManifestHeaderContext context) {
            Character nextChar = context.buffer();
            if (nextChar == null) {
                return false;
            }
            if (Character.isLetter(nextChar) || nextChar.equals('.')) {
                context.addNextTokenChar(nextChar);
            } else if (nextChar.equals(';')) {
                context.setState(States.DETAILS);
                context.addPackage();
                context.startToken();
            }
            return true;
        }
    },
    DETAILS {
        public boolean process(ManifestHeaderContext context) {
            Character nextChar = context.buffer();
            if (nextChar == null) {
                return false;
            }
            if (nextChar.equals(';')) {
                context.startToken();
            } else if (!nextChar.equals(',')) {
                context.addNextTokenChar(nextChar);
                if (context.getToken().equalsIgnoreCase("uses:=\"")) {
                    context.setState(States.USES);
                    context.startToken();
                } else if (context.getToken().equalsIgnoreCase("version=\"")) {
                    context.setState(States.VERSION);
                    context.startToken();
                }
            } else {
                context.startToken();
            }
            return true;
        }
    },
    USES {
        public boolean process(ManifestHeaderContext context) {
            Character nextChar = context.buffer();
            if (nextChar == null) {
                return false;
            }
            if (!nextChar.equals('"')) {
                context.addNextTokenChar(nextChar);
            } else {
                context.addUses();
                context.setState(States.DETAILS);
                context.startToken();
            }
            return true;
        }
    },
    VERSION {
        public boolean process(ManifestHeaderContext context) {
            Character nextChar = context.buffer();
            if (nextChar == null) {
                return false;
            }
            if (!nextChar.equals('"')) {
                context.addNextTokenChar(nextChar);
            } else {
                context.addVersion();
                context.setState(States.PACKAGE);
                context.startToken();
            }
            return true;
        }
    }

}
