package de.twenty11.skysail.common.ext.osgimonitor.internal;

import java.util.ArrayList;
import java.util.List;

public class ManifestExportHeaderContext implements ManifestHeaderContext {

    private String stringToParse;
    int i = 0;
    private State state = States.PACKAGE;
    private char[] token = new char[0];
    private List<PackageDesc> packages = new ArrayList<PackageDesc>();

    private class PackageDesc {

        private String name;
        private UsesDesc uses;
        private VersionDesc version;

        public PackageDesc(String string) {
            this.name = string;
        }

        public String getName() {
            return name;
        }

        public void addUses(UsesDesc usesDesc) {
            this.uses = usesDesc;
        }

        public void addVersion(VersionDesc versionDesc) {
            this.version = versionDesc;
        }

        public VersionDesc getVersion() {
            return this.version;
        }
    }

    public class UsesDesc {

        private String uses;

        public UsesDesc(String string) {
            this.uses = string;
        }

    }

    public class VersionDesc {
        private String version;

        public VersionDesc(String string) {
            this.version = string;
        }

        public String getVersion() {
            return version;
        }
    }

    public ManifestExportHeaderContext(String stringToParse) {
        this.stringToParse = stringToParse;
    }

    @Override
    public Character buffer() {
        if (stringToParse.length() <= i) {
            return null;
        }
        char nextChar = stringToParse.charAt(i++);
        return nextChar;
    }

    @Override
    public State getState() {
        return state;
    }

    @Override
    public void setState(State state) {
        this.state = state;
    }

    @Override
    public void startToken() {
        this.token = new char[0];
    }

    @Override
    public void addNextTokenChar(Character nextChar) {
        token = (new String(token) + nextChar).toCharArray();
    }

    @Override
    public String getToken() {
        return new String(token);
    }

    @Override
    public void addPackage() {
        StringBuilder result = new StringBuilder();
        for (Character character : token) {
            result.append(character);
        }
        this.packages.add(new PackageDesc(result.toString()));
    }

    @Override
    public void addUses() {
        if (packages.size() > 0) {
            packages.get(packages.size() - 1).addUses(new UsesDesc(new String(token)));
        }
    }

    @Override
    public void addVersion() {
        if (packages.size() > 0) {
            packages.get(packages.size() - 1).addVersion(new VersionDesc(new String(token)));
        }
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder result = new StringBuilder();
        boolean found = false;
        for (PackageDesc pkg : packages) {
            found = true;
            result.append(pkg.getName());
            if (pkg.getVersion() != null) {
                result.append(";version=\"").append(pkg.getVersion().version).append("\"");
            }
            result.append(",").append("<br>\n");
        }
        result = getRidOfLastCommaIfNecessary(result, found);
        return result.toString();
    }

    private StringBuilder getRidOfLastCommaIfNecessary(StringBuilder result, boolean found) {
        if (found) {
            result = result.delete(result.length() - 6, result.length() - 5);
        }
        return result;
    }

}
