package de.twenty11.skysail.common.ext.osgimonitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.persistence.Transient;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.restlet.data.Reference;

import de.twenty11.skysail.common.Presentable;
import de.twenty11.skysail.common.PresentableHeader;

public class ServiceDescriptor implements Serializable, Presentable {

	private static final long serialVersionUID = -557374476304687619L;

	@Transient
	private Map<String, String> links;

	private BundleDescriptor providingBundle;
	
    @Transient
    private List<BundleDescriptor> usingBundles = new ArrayList<BundleDescriptor>();

	private Map<String, Object> properties = new HashMap<String,Object>();

	@Transient
    private Reference reference;

    private String stringRep;

	public ServiceDescriptor() {
	}
	
	public ServiceDescriptor(ServiceReference sr, Reference reference) {
		providingBundle = new BundleDescriptor(sr.getBundle(), reference);
		this.reference = reference;
        if (sr.getUsingBundles() != null) {
            for (Bundle usingBundle : sr.getUsingBundles()) {
                usingBundles.add(new BundleDescriptor(usingBundle, reference));
            }
        }
		String[] propertyKeys = sr.getPropertyKeys();
		for (String key : propertyKeys) {
			properties.put(key, sr.getProperty(key));
		}
        this.stringRep = sr.toString();
	}
	
	public Map<String, Object> getProperties() {
		return properties;
	}
	
	public void setProperties(Map<String, Object> properties) {
		this.properties = properties;
	}
	
	public BundleDescriptor getProvidingBundle() {
		return providingBundle;
	}
	
	public void setProvidingBundle(BundleDescriptor providingBundle) {
		this.providingBundle = providingBundle;
	}
	

    @Override
    @JsonIgnore
    public PresentableHeader getHeader() {
        String serviceId = ((Long) properties.get("service.id")).toString();
        return new PresentableHeader.Builder("#" + serviceId + ": " + this.stringRep).build();
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getContent() {
        Map<String, Object> result = new HashMap<String, Object>();
        result.put("provided by", providingBundle);
        result.put("used by", usingBundles);
        for (String property : this.properties.keySet()) {
            result.put(property, properties.get(property));
        }
        return result;
    }

}
