package de.twenty11.skysail.common.ext.osgimonitor;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.osgi.framework.Bundle;

import de.twenty11.skysail.common.Presentable;
import de.twenty11.skysail.common.PresentableHeader;
import de.twenty11.skysail.common.ext.osgimonitor.internal.ManifestExportHeaderContext;
import de.twenty11.skysail.common.ext.osgimonitor.internal.ManifestHeaderContext;

public class HeaderDescriptor implements Presentable, Serializable {

    public static final String EXPORT_PACKAGE = "Export-Package";
    private static final long serialVersionUID = -757592664368721066L;
    private Map<String, Object> headers = new TreeMap<String, Object>();
    private Bundle bundle;

    public HeaderDescriptor() {
    }

    public HeaderDescriptor(Bundle bundle) {
        this.bundle = bundle;
        
        Enumeration keys = bundle.getHeaders().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = bundle.getHeaders().get(key);
            this.headers.put(key.toString(), value == null ? "-null-" : value.toString());
        }
        
        final String exportPackage = (String) headers.get(EXPORT_PACKAGE);
        if (exportPackage != null) {
            ManifestHeaderContext exportPackageContext = new ManifestExportHeaderContext(exportPackage);
            while (exportPackageContext.getState().process(exportPackageContext))
                ;
            this.headers.put(EXPORT_PACKAGE, exportPackageContext.getStringRepresentation());
        }
    }

    public PresentableHeader getHeader() {
        return new PresentableHeader.Builder("Headers of Bundle" + bundle.getSymbolicName()).build();
    }

    public Map<String, Object> getContent() {
        return this.headers;
    }


}
