/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.ext.osgimonitor;

import de.twenty11.skysail.common.DetailsLinkProvider;
import de.twenty11.skysail.common.ext.osgimonitor.BundleDescriptor;
import de.twenty11.skysail.common.ext.osgimonitor.ServiceReferenceDetails;
import de.twenty11.skysail.common.graphs.EdgeProvider;
import de.twenty11.skysail.common.graphs.NodeProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class BundleDetails
extends BundleDescriptor
implements DetailsLinkProvider {
    private List<ServiceReferenceDetails> registeredServices = new ArrayList<ServiceReferenceDetails>();
    private List<ServiceReferenceDetails> servicesInUse = new ArrayList<ServiceReferenceDetails>();

    public BundleDetails() {
    }

    public BundleDetails(Bundle bundle) {
        super(bundle);
        this.getRegisteredServicesFromBundle(bundle);
        this.getUsedServicesFromBundle(bundle);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.symbolicName).append(", ");
        return sb.toString();
    }

    public void setRegisteredServices(List<ServiceReferenceDetails> list) {
        this.registeredServices = list;
    }

    public List<ServiceReferenceDetails> getRegisteredServices() {
        return this.registeredServices;
    }

    public void setServicesInUse(List<ServiceReferenceDetails> list) {
        this.servicesInUse = list;
    }

    public List<ServiceReferenceDetails> getServicesInUse() {
        return this.servicesInUse;
    }

    @JsonIgnore
    public NodeProvider asNode() {
        return new NodeProvider(){

            public String getType() {
                return BundleDetails.this.getClass().getCanonicalName();
            }

            public Map<String, String> getNodeProperties() {
                return Collections.emptyMap();
            }

            public String getNodeLabel() {
                return BundleDetails.this.symbolicName + "(" + BundleDetails.this.version.toString() + ")";
            }

            public String getNodeId() {
                return Long.toString(BundleDetails.this.bundleId);
            }

            public List<EdgeProvider> getEdges() {
                ArrayList<EdgeProvider> result = new ArrayList<EdgeProvider>();
                for (final ServiceReferenceDetails srd : BundleDetails.this.registeredServices) {
                    if (srd.getUsingBundles().size() == 0) continue;
                    for (final BundleDetails usingBundle : srd.getUsingBundles()) {
                        EdgeProvider edgeProvider = new EdgeProvider(){

                            public int getWeight() {
                                return 1;
                            }

                            public String getTarget() {
                                return Long.toString(usingBundle.getBundleId());
                            }

                            public String getSource() {
                                return BundleDetails.this.asNode().getNodeId();
                            }

                            public Map<String, String> getEdgeProperties() {
                                return Collections.emptyMap();
                            }

                            public String getEdgeLabel() {
                                return srd.getName();
                            }

                            public String getEdgeId() {
                                return srd.getName();
                            }
                        };
                        result.add(edgeProvider);
                    }
                }
                return result;
            }
        };
    }

    private void getRegisteredServicesFromBundle(Bundle bundle) {
        this.setRegisteredServices(this.getDetails(bundle.getRegisteredServices()));
    }

    private void getUsedServicesFromBundle(Bundle bundle) {
        this.setServicesInUse(this.getDetails(bundle.getServicesInUse()));
    }

    private List<ServiceReferenceDetails> getDetails(ServiceReference[] serviceReferences) {
        ArrayList<ServiceReferenceDetails> serviceDetails = new ArrayList<ServiceReferenceDetails>();
        if (serviceReferences == null) {
            return serviceDetails;
        }
        for (ServiceReference sr : serviceReferences) {
            serviceDetails.add(new ServiceReferenceDetails(sr));
        }
        return serviceDetails;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getLinkMap() {
        HashMap<String, String> links = new HashMap<String, String>();
        links.put("start", "/start?media=putform");
        links.put("stop", "/stop?media=putform");
        links.put("update", "/update?media=putform");
        return links;
    }
}

