package de.twenty11.skysail.common.ext.osgimonitor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.codehaus.jackson.annotate.JsonSetter;
import javax.persistence.Transient;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

import de.twenty11.skysail.common.DetailsLinkProvider;

public class BundleDescriptor implements DetailsLinkProvider, Serializable {

	public static final String SYMBOLIC_NAME = "symbolicName";

	private static final long serialVersionUID = -3490514848138717614L;

	protected long bundleId;

	protected String symbolicName;

	protected String version;

	protected long lastModified;

	protected String state;

	@Transient
	private Map<String, String> links;

	public BundleDescriptor() {
	}

	public BundleDescriptor(Bundle bundle) {
		this.bundleId = bundle.getBundleId();
		this.symbolicName = bundle.getSymbolicName();
		this.version = handleVersion(bundle.getVersion());
		this.lastModified = bundle.getLastModified();
		this.state = mapState(bundle.getState());
	}

	private String mapState(int state) {
		switch (state) {
			case 1 :
				return "Uninstalled";
			case 2 :
				return "Installed";
			case 4 :
				return "Resolved";
			case 8 :
				return "Starting";
			case 16 :
				return "Stopping";
			case 32 :
				return "Active";
			default :
				return "unknown state";
		}
	}

	private String handleVersion(Version version) {
		StringBuffer sb = new StringBuffer();
		sb.append(version.getMajor()).append(".");
		sb.append(version.getMinor()).append(".");
		sb.append(version.getMicro()).append(".");
		sb.append(version.getQualifier());
		return sb.toString();
	}

	public String getSymbolicName() {
		return symbolicName;
	}

	public void setSymbolicName(String symbolicName) {
		this.symbolicName = symbolicName;
	}

	public void setBundleId(long bundleId) {
		this.bundleId = bundleId;
	}

	public long getBundleId() {
		return bundleId;
	}

	public void setLastModified(long lastModified) {
		this.lastModified = lastModified;
	}

	public long getLastModified() {
		return lastModified;
	}

	@JsonSetter
	public void setState(String state) {
		this.state = state;
	}

	public void setState(Integer state) {
		this.state = mapState(state);
	}

	public String getState() {
		return state;
	}

	public void setVersion(Version version) {
		this.version = handleVersion(version);
	}

	public String getVersion() {
		return version;
	}

	@Override
	@JsonIgnore
	public Map<String, String> getLinkMap() {
		Map<String, String> links = new HashMap<String, String>();
		links.put("bundleLink", "/details/" + this.bundleId);
		return links;
	}

	@Override
	public void setLinks(Map<String, String> links) {
		this.links = links;
	}

	@Override
	public Map<String, String> getLinks() {
		return links;
	}

}
