/*
 * Decompiled with CFR 0.152.
 */
package de.twenty11.skysail.common.ext.osgimonitor;

import de.twenty11.skysail.common.ext.osgimonitor.ServiceReferenceDetails;
import de.twenty11.skysail.common.graphs.EdgeProvider;
import de.twenty11.skysail.common.graphs.NodeProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.osgi.framework.Version;

public class BundleDetails
implements Serializable {
    private static final long serialVersionUID = -1079406626730388016L;
    public static final String SYMBOLIC_NAME = "symbolicName";
    private String symbolicName;
    private long bundleId;
    private long lastModified;
    private List<ServiceReferenceDetails> registeredServices = new ArrayList<ServiceReferenceDetails>();
    private List<ServiceReferenceDetails> servicesInUse = new ArrayList<ServiceReferenceDetails>();
    private int state;
    private Version version;

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.symbolicName).append(", ");
        return sb.toString();
    }

    public void setBundleId(long bundleId) {
        this.bundleId = bundleId;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setRegisteredServices(List<ServiceReferenceDetails> list) {
        this.registeredServices = list;
    }

    public List<ServiceReferenceDetails> getRegisteredServices() {
        return this.registeredServices;
    }

    public void setServicesInUse(List<ServiceReferenceDetails> list) {
        this.servicesInUse = list;
    }

    public List<ServiceReferenceDetails> getServicesInUse() {
        return this.servicesInUse;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    @JsonIgnore
    public NodeProvider asNode() {
        return new NodeProvider(){

            public String getType() {
                return BundleDetails.this.getClass().getCanonicalName();
            }

            public Map<String, String> getNodeProperties() {
                return Collections.emptyMap();
            }

            public String getNodeLabel() {
                return BundleDetails.this.symbolicName + "(" + BundleDetails.this.version.toString() + ")";
            }

            public String getNodeId() {
                return Long.toString(BundleDetails.this.bundleId);
            }

            public List<EdgeProvider> getEdges() {
                ArrayList<EdgeProvider> result = new ArrayList<EdgeProvider>();
                for (final ServiceReferenceDetails srd : BundleDetails.this.registeredServices) {
                    if (srd.getUsingBundles().size() == 0) continue;
                    for (final BundleDetails usingBundle : srd.getUsingBundles()) {
                        EdgeProvider edgeProvider = new EdgeProvider(){

                            public int getWeight() {
                                return 1;
                            }

                            public String getTarget() {
                                return Long.toString(usingBundle.getBundleId());
                            }

                            public String getSource() {
                                return BundleDetails.this.asNode().getNodeId();
                            }

                            public Map<String, String> getEdgeProperties() {
                                return Collections.emptyMap();
                            }

                            public String getEdgeLabel() {
                                return srd.getName();
                            }

                            public String getEdgeId() {
                                return srd.getName();
                            }
                        };
                        result.add(edgeProvider);
                    }
                }
                return result;
            }
        };
    }
}

