/*
 * Decompiled with CFR 0.152.
 */
package de.turnertech.tz.symbol;

import java.util.Objects;
import java.util.Optional;

public enum TacticalSymbolTag {
    THW("thw"),
    FIRE_BRIGADE("fw"),
    MILITARY("bw"),
    POLICE("polizei"),
    CUSTOMS("zoll"),
    UNIT("einheiten"),
    BUILDING("geb\u00e4ude"),
    FACILITIES("einrichtungen"),
    MEASURES("ma\u00dfnahmen"),
    DAMAGE("sch\u00e4den"),
    DAMAGE_ACCOUNTS("schadenskonten"),
    PERSON("personen"),
    OTHER("sonstiges"),
    HAZARDS("gefahren"),
    VEHICLE("fahrzeuge"),
    WATER_RESCUE("wasserrettung"),
    CIVIL_PROTECTION("katastrophenschutz"),
    RESCUE_SERVICES("rettungswesen"),
    LEADERSHIP("f\u00fchrungsstellen"),
    TELECOMMUNICATIONS("fernmeldewesen");

    private final String label;

    private TacticalSymbolTag(String label) {
        Objects.requireNonNull(label);
        this.label = label;
    }

    public static Optional<TacticalSymbolTag> from(String label) {
        for (TacticalSymbolTag tag : TacticalSymbolTag.values()) {
            if (!tag.label.equals(label)) continue;
            return Optional.of(tag);
        }
        return Optional.empty();
    }
}

