/*
 * Decompiled with CFR 0.152.
 */
package de.turnertech.tz.symbol;

import de.turnertech.tz.symbol.TacticalSymbolResource;
import de.turnertech.tz.symbol.TacticalSymbolTag;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TacticalSymbolResourceFactory {
    private static ArrayList<TacticalSymbolResource> tacticalSymbols;
    public static final String LOGGER_NAME = "de.turnertech.tz";
    static final Logger logger;

    private TacticalSymbolResourceFactory() {
    }

    public static boolean initialise() {
        if (tacticalSymbols != null) {
            logger.warning("Detected repeated calls to initialise. This should not happen, the factory cannot be initialised twice.");
            return true;
        }
        try (InputStream input = TacticalSymbolResourceFactory.class.getResourceAsStream("index");){
            tacticalSymbols = new ArrayList(1000);
            Scanner scanner = new Scanner(input, "UTF-8");
            while (scanner.hasNextLine()) {
                String[] line = scanner.nextLine().split(",");
                URL resource = TacticalSymbolResourceFactory.class.getResource(line[0]);
                ArrayList<TacticalSymbolTag> tagList = new ArrayList<TacticalSymbolTag>();
                for (int i = 1; i < line.length; ++i) {
                    tagList.add(TacticalSymbolTag.from(line[i]).orElseThrow());
                }
                tagList.trimToSize();
                tacticalSymbols.add(new TacticalSymbolResource(resource, tagList));
            }
            scanner.close();
            tacticalSymbols.trimToSize();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Could not read the index file! This is an internal failure, please report it to the project");
            logger.log(Level.SEVERE, exception.toString());
            tacticalSymbols = null;
            return false;
        }
        return true;
    }

    public static void reset() {
        tacticalSymbols = null;
    }

    public static boolean isInitialised() {
        return tacticalSymbols != null;
    }

    public static Collection<TacticalSymbolResource> getTacticalSymbols(TacticalSymbolTag ... tags) {
        if (!TacticalSymbolResourceFactory.isInitialised()) {
            TacticalSymbolResourceFactory.initialise();
        }
        LinkedList<TacticalSymbolResource> returnList = new LinkedList<TacticalSymbolResource>();
        for (TacticalSymbolResource tacticalSymbol : tacticalSymbols) {
            if (!tacticalSymbol.getTags().containsAll(Arrays.asList(tags))) continue;
            returnList.add(tacticalSymbol);
        }
        return returnList;
    }

    public static Collection<TacticalSymbolResource> getTacticalSymbols() {
        if (!TacticalSymbolResourceFactory.isInitialised()) {
            TacticalSymbolResourceFactory.initialise();
        }
        return Collections.unmodifiableCollection(tacticalSymbols);
    }

    static {
        logger = Logger.getLogger(LOGGER_NAME);
    }
}

