/*
 * Decompiled with CFR 0.152.
 */
package de.turnertech.tz.symbol;

import de.turnertech.tz.symbol.TacticalSymbolResourceFactory;
import de.turnertech.tz.symbol.TacticalSymbolTag;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class TacticalSymbolResource {
    private final URL resource;
    private final Collection<TacticalSymbolTag> tags;

    TacticalSymbolResource(URL resource, Collection<TacticalSymbolTag> tags) {
        Objects.requireNonNull(resource, "TacticalSymbol cannot be created with a null resource!");
        this.tags = tags == null ? Collections.emptyList() : Collections.unmodifiableCollection(tags);
        this.resource = resource;
    }

    public URL getResourceURL() {
        return this.resource;
    }

    public Collection<TacticalSymbolTag> getTags() {
        return this.tags;
    }

    public boolean hasTag(TacticalSymbolTag tag) {
        return this.tags.contains((Object)tag);
    }

    public String toString() {
        String filename = this.resource.toString();
        try {
            filename = URLDecoder.decode(filename, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            TacticalSymbolResourceFactory.logger.severe("Could not decode the filepath to a UTF-8 String! Tell this to a Dev");
        }
        return filename.substring(filename.lastIndexOf(47) + 1, filename.length() - 4);
    }
}

