/*
 * Decompiled with CFR 0.152.
 */
package de.turnertech.tz.swing;

import de.turnertech.tz.swing.TacticalSymbol;
import de.turnertech.tz.symbol.TacticalSymbolResource;
import de.turnertech.tz.symbol.TacticalSymbolResourceFactory;
import de.turnertech.tz.symbol.TacticalSymbolTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import java.util.logging.Logger;

public class TacticalSymbolFactory {
    private static ArrayList<TacticalSymbol> tacticalSymbols;
    public static final String LOGGER_NAME = "de.turnertech.tz";
    static final Logger logger;

    private TacticalSymbolFactory() {
    }

    public static boolean initialise() {
        if (tacticalSymbols != null) {
            logger.warning("Detected repeated calls to initialise. This should not happen, the factory cannot be initialised twice.");
            return true;
        }
        if (!TacticalSymbolResourceFactory.initialise()) {
            logger.severe("Could not initialised the symbol.TacticalSymbolFactory!");
            return false;
        }
        Collection symbols = TacticalSymbolResourceFactory.getTacticalSymbols();
        tacticalSymbols = new ArrayList(symbols.size());
        for (TacticalSymbolResource symbol : symbols) {
            tacticalSymbols.add(new TacticalSymbol(symbol));
        }
        return true;
    }

    public static void reset() {
        tacticalSymbols = null;
        TacticalSymbolResourceFactory.reset();
    }

    public static boolean isInitialised() {
        return tacticalSymbols != null;
    }

    public static Collection<TacticalSymbol> getTacticalSymbols(TacticalSymbolTag ... tags) {
        if (!TacticalSymbolFactory.isInitialised()) {
            TacticalSymbolFactory.initialise();
        }
        LinkedList<TacticalSymbol> returnList = new LinkedList<TacticalSymbol>();
        for (TacticalSymbol tacticalSymbol : tacticalSymbols) {
            if (!tacticalSymbol.getTags().containsAll(Arrays.asList(tags))) continue;
            returnList.add(tacticalSymbol);
        }
        return returnList;
    }

    public static Optional<TacticalSymbol> getTacticalSymbol(int hashCode) {
        for (TacticalSymbol tacticalSymbol : tacticalSymbols) {
            if (tacticalSymbol.hashCode() != hashCode) continue;
            return Optional.of(tacticalSymbol);
        }
        return Optional.empty();
    }

    public static Collection<TacticalSymbol> getTacticalSymbols() {
        if (!TacticalSymbolFactory.isInitialised()) {
            TacticalSymbolFactory.initialise();
        }
        return Collections.unmodifiableCollection(tacticalSymbols);
    }

    static {
        logger = Logger.getLogger(LOGGER_NAME);
    }
}

