/*
 * Decompiled with CFR 0.152.
 */
package de.turnertech.tz.swing;

import de.turnertech.tz.symbol.TacticalSymbolResource;
import de.turnertech.tz.symbol.TacticalSymbolTag;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.swing.ImageIcon;

public class TacticalSymbol
implements Transferable {
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(TacticalSymbol.class, "Tactical Symbol");
    private static final DataFlavor[] possibleDataFlavors = new DataFlavor[]{DATA_FLAVOR, DataFlavor.stringFlavor, DataFlavor.imageFlavor};
    private final TacticalSymbolResource symbol;
    private ImageIcon imageIcon;
    public static final int DEFAULT_SCALING_METHOD = 4;
    private ArrayList<AbstractMap.SimpleEntry<Integer, ImageIcon>> cache = new ArrayList(2);

    TacticalSymbol(TacticalSymbolResource symbol) {
        Objects.requireNonNull(symbol, "Cannot create a swing.TacticalSymbol without a symbol.TacticalSymbol");
        this.symbol = symbol;
    }

    public Collection<TacticalSymbolTag> getTags() {
        return this.symbol.getTags();
    }

    public ImageIcon getImageIcon() {
        if (this.imageIcon == null) {
            this.imageIcon = new ImageIcon(this.symbol.getResourceURL());
            this.imageIcon.setDescription(this.symbol.toString());
            int cacheKey = this.getCacheKey(this.imageIcon.getIconWidth(), this.imageIcon.getIconHeight(), 4);
            this.cache.add(new AbstractMap.SimpleEntry<Integer, ImageIcon>(cacheKey, this.imageIcon));
        }
        return this.imageIcon;
    }

    public ImageIcon getImageIcon(int width, int height) {
        return this.getImageIcon(width, height, 4);
    }

    public ImageIcon getImageIcon(int width, int height, int method) {
        int cacheKey = this.getCacheKey(width, height, method);
        Optional<ImageIcon> cacheItem = this.getCacheItem(cacheKey);
        if (cacheItem.isPresent()) {
            return cacheItem.get();
        }
        ImageIcon origional = this.getImageIcon();
        ImageIcon scaled = new ImageIcon(origional.getImage().getScaledInstance(height, width, method));
        scaled.setDescription(this.symbol.toString());
        this.cache.add(new AbstractMap.SimpleEntry<Integer, ImageIcon>(cacheKey, scaled));
        return scaled;
    }

    public URL getImageURL() {
        return this.symbol.getResourceURL();
    }

    private int getCacheKey(int w, int h, int method) {
        return w * 1000000 + h * 100 + method;
    }

    private Optional<ImageIcon> getCacheItem(int key) {
        for (AbstractMap.SimpleEntry<Integer, ImageIcon> cacheItem : this.cache) {
            if (!cacheItem.getKey().equals(key)) continue;
            return Optional.of(cacheItem.getValue());
        }
        return Optional.empty();
    }

    public String toString() {
        return this.symbol.toString();
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(DATA_FLAVOR)) {
            return this;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return this.toString();
        }
        if (dataFlavor.equals(DataFlavor.imageFlavor)) {
            return this.getImageIcon().getImage();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return possibleDataFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (DataFlavor possibleDataFlavor : possibleDataFlavors) {
            if (!possibleDataFlavor.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        return Integer.valueOf(this.hashCode()).equals(Objects.hashCode(other));
    }

    public int hashCode() {
        return Objects.hash(this.symbol.hashCode(), "swing.TacticalSymbol");
    }
}

