/*
 * Decompiled with CFR 0.152.
 */
package de.turnertech.measures;

import de.turnertech.measures.Measure;
import de.turnertech.measures.Unit;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;

public class UnitConverter {
    private static final HashMap<AbstractMap.SimpleImmutableEntry<Unit, Unit>, Double> scalarMap = new HashMap();
    private static final HashMap<AbstractMap.SimpleImmutableEntry<Unit, Unit>, DoubleUnaryOperator> functionMap = new HashMap();

    public static Double putScalar(Unit unitIn, Unit unitOut, double scalar) {
        if (scalar == 0.0) {
            throw new ArithmeticException("scalar values of 0 are not accepted in the UnitConverter.");
        }
        return scalarMap.put(new AbstractMap.SimpleImmutableEntry<Unit, Unit>(Objects.requireNonNull(unitIn), Objects.requireNonNull(unitOut)), scalar);
    }

    public static DoubleUnaryOperator putFunction(Unit unitIn, Unit unitOut, DoubleUnaryOperator function) {
        return functionMap.put(new AbstractMap.SimpleImmutableEntry<Unit, Unit>(Objects.requireNonNull(unitIn), Objects.requireNonNull(unitOut)), Objects.requireNonNull(function));
    }

    public static Measure convert(Measure in, Unit unitOut) {
        Objects.requireNonNull(in);
        return UnitConverter.convert(in.getQuantity(), in.getUnit(), unitOut);
    }

    public static Measure convert(double in, Unit unitIn, Unit unitOut) {
        Objects.requireNonNull(unitIn);
        Objects.requireNonNull(unitOut);
        if (unitIn == unitOut) {
            return new Measure(in, unitOut);
        }
        DoubleUnaryOperator conversionFunction = functionMap.getOrDefault(new AbstractMap.SimpleImmutableEntry<Unit, Unit>(unitIn, unitOut), null);
        if (conversionFunction != null) {
            return new Measure(conversionFunction.applyAsDouble(in), unitOut);
        }
        Double variable = scalarMap.getOrDefault(new AbstractMap.SimpleImmutableEntry<Unit, Unit>(unitIn, unitOut), null);
        if (variable != null) {
            return new Measure(in * variable, unitOut);
        }
        variable = scalarMap.getOrDefault(new AbstractMap.SimpleImmutableEntry<Unit, Unit>(unitOut, unitIn), null);
        if (variable != null) {
            return new Measure(in / variable, unitOut);
        }
        if (unitIn.getBaseUnit() == unitOut.getBaseUnit()) {
            Measure inInBaseUnit = unitIn.convertToBaseUnit(in);
            return unitOut.convertFromBaseUnit(inInBaseUnit.getQuantity());
        }
        throw new UnsupportedOperationException("Conversion from " + unitIn.toString() + " to " + unitOut.toString() + " is not supported.");
    }

    static {
        scalarMap.put(new AbstractMap.SimpleImmutableEntry<Unit, Unit>(Unit.NAUTICAL_MILE, Unit.CENTIMETRE), 185200.0);
        scalarMap.put(new AbstractMap.SimpleImmutableEntry<Unit, Unit>(Unit.NAUTICAL_MILE, Unit.METRE), 1852.0);
        scalarMap.put(new AbstractMap.SimpleImmutableEntry<Unit, Unit>(Unit.NAUTICAL_MILE, Unit.KILOMETRE), 1.852);
        scalarMap.put(new AbstractMap.SimpleImmutableEntry<Unit, Unit>(Unit.KILOMETRE, Unit.METRE), 1000.0);
        scalarMap.put(new AbstractMap.SimpleImmutableEntry<Unit, Unit>(Unit.KILOMETRE, Unit.CENTIMETRE), 100000.0);
        functionMap.put(new AbstractMap.SimpleImmutableEntry<Unit, Unit>(Unit.NAUTICAL_MILE, Unit.KILOMETRE), nmi_i -> nmi_i * 1.852);
    }
}

