/*
 * Decompiled with CFR 0.152.
 */
package de.turnertech.measures;

import de.turnertech.measures.Measure;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;

public class Unit {
    public static final Unit KELVIN = new Unit(null, kelvin -> kelvin, kelvin -> kelvin);
    public static final Unit DEGREES_CELSIUS = new Unit(KELVIN, celsius -> celsius + 273.15, kelvin -> kelvin - 273.15);
    public static final Unit DEGREES_FAHRENHEIT = new Unit(KELVIN, fahrenheit -> (fahrenheit - 32.0) * 5.0 / 9.0 + 273.15, kelvin -> (kelvin - 273.15) * 9.0 / 5.0 + 32.0);
    public static final Unit METRE = new Unit(null, metre -> metre, kelvin -> kelvin);
    public static final Unit CENTIMETRE = new Unit(METRE, centimetre -> centimetre * 0.01, metre -> metre * 100.0);
    public static final Unit INCH = new Unit(METRE, inch -> inch * 0.0254, metre -> metre / 0.0254);
    public static final Unit FOOT = new Unit(METRE, foot -> foot * 0.3048, metre -> metre / 0.3048);
    public static final Unit YARD = new Unit(METRE, yard -> yard * 0.9144, metre -> metre / 0.9144);
    public static final Unit MILE = new Unit(METRE, mile -> mile * 1609.344, metre -> metre / 1609.344);
    public static final Unit KILOMETRE = new Unit(METRE, kilometer -> kilometer * 1000.0, metre -> metre * 0.001);
    public static final Unit NAUTICAL_MILE = new Unit(METRE, nmi_i -> nmi_i * 1852.0, metre -> metre / 1852.0);
    public static final Unit SECOND = new Unit(null, second -> second, second -> second);
    public static final Unit GRAM = new Unit(null, gram -> gram, gram -> gram);
    public static final Unit POUND = new Unit(GRAM, gram -> gram * 453.59237, pound -> pound / 453.59237);
    public static final Unit RADIAN = new Unit(null, rad -> rad, rad -> rad);
    public static final Unit DEGREE = new Unit(RADIAN, deg -> deg * Math.PI / 180.0, rad -> rad * 180.0 / Math.PI);
    private final Unit baseUnit;
    private final DoubleUnaryOperator toBaseUnitFunction;
    private final DoubleUnaryOperator fromBaseUnitFunction;

    private Unit(Unit baseUnit, DoubleUnaryOperator toBaseUnitFunction, DoubleUnaryOperator fromBaseUnitFunction) {
        this.baseUnit = Objects.requireNonNullElse(baseUnit, this);
        this.toBaseUnitFunction = Objects.requireNonNull(toBaseUnitFunction);
        this.fromBaseUnitFunction = Objects.requireNonNull(fromBaseUnitFunction);
    }

    public Measure createMeasure(double quantity) {
        return new Measure(quantity, this);
    }

    public Unit getBaseUnit() {
        return this.baseUnit;
    }

    public Measure convertToBaseUnit(double quantity) {
        Measure resultingValue = new Measure(this.toBaseUnitFunction.applyAsDouble(quantity), this.baseUnit);
        if (quantity != Double.POSITIVE_INFINITY && quantity != Double.POSITIVE_INFINITY && (resultingValue.getQuantity() == Double.NEGATIVE_INFINITY || resultingValue.getQuantity() == Double.POSITIVE_INFINITY)) {
            throw new ArithmeticException("Conversion caused overflow.");
        }
        return resultingValue;
    }

    public Measure convertFromBaseUnit(double quantity) {
        Measure resultingValue = new Measure(this.fromBaseUnitFunction.applyAsDouble(quantity), this);
        if (quantity != Double.POSITIVE_INFINITY && quantity != Double.POSITIVE_INFINITY && (resultingValue.getQuantity() == Double.NEGATIVE_INFINITY || resultingValue.getQuantity() == Double.POSITIVE_INFINITY)) {
            throw new ArithmeticException("Conversion caused overflow.");
        }
        return resultingValue;
    }
}

