/*
 * Decompiled with CFR 0.152.
 */
package de.turnertech.measures;

import de.turnertech.measures.Unit;
import de.turnertech.measures.UnitConverter;
import java.util.Objects;

public class Measure {
    private double quantity;
    private final Unit unit;

    public Measure(double quantity, Unit unit) {
        this.quantity = quantity;
        this.unit = Objects.requireNonNull(unit, "Unit instance provided to Measure constructor may not be null");
    }

    public boolean equalsWithTolerance(Measure other, double tolerance) {
        Measure otherInThisUnit = UnitConverter.convert(other.quantity, other.unit, this.unit);
        double difference = Math.abs(this.quantity - otherInThisUnit.quantity);
        return difference <= tolerance;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Measure convertTo(Unit newUnit) {
        return UnitConverter.convert(this, newUnit);
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + (int)(Double.doubleToLongBits(this.quantity) ^ Double.doubleToLongBits(this.quantity) >>> 32);
        hash = 61 * hash + Objects.hashCode(this.unit);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Measure other = (Measure)obj;
        if (Double.doubleToLongBits(this.quantity) != Double.doubleToLongBits(other.quantity)) {
            return false;
        }
        return Objects.equals(this.unit, other.unit);
    }
}

