/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.ase.parser.strategy;

import de.tum.in.ase.parser.strategy.CheckstyleParser;
import de.tum.in.ase.parser.strategy.PMDParser;
import de.tum.in.ase.parser.strategy.ParserStrategy;
import de.tum.in.ase.parser.strategy.SpotbugsParser;
import java.util.Objects;
import java.util.Optional;

public enum StaticCodeAnalysisTool {
    SPOTBUGS("BugCollection", new SpotbugsParser()),
    CHECKSTYLE("checkstyle", new CheckstyleParser()),
    PMD("pmd", new PMDParser());

    private String identifierTag;
    private ParserStrategy strategy;

    private StaticCodeAnalysisTool(String identifyingTag, ParserStrategy strategy) {
        this.identifierTag = identifyingTag;
        this.strategy = strategy;
    }

    public String getIdentifyingTag() {
        return this.identifierTag;
    }

    public ParserStrategy getStrategy() {
        return this.strategy;
    }

    public static Optional<StaticCodeAnalysisTool> getToolByIdentifierTag(String identifierTag) {
        for (StaticCodeAnalysisTool tool : StaticCodeAnalysisTool.values()) {
            if (!Objects.equals(identifierTag, tool.getIdentifyingTag())) continue;
            return Optional.of(tool);
        }
        return Optional.empty();
    }
}

