/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.ase.parser.strategy;

import de.tum.in.ase.parser.domain.Issue;
import de.tum.in.ase.parser.domain.Report;
import de.tum.in.ase.parser.strategy.ParserStrategy;
import de.tum.in.ase.parser.strategy.ParserUtils;
import de.tum.in.ase.parser.strategy.StaticCodeAnalysisTool;
import java.util.ArrayList;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;

class SpotbugsParser
implements ParserStrategy {
    private static final String BUGINSTANCE_ELEMENT = "BugInstance";
    private static final String BUGINSTANCE_ATT_TYPE = "type";
    private static final String BUGINSTANCE_ATT_CATEGORY = "category";
    private static final String BUGINSTANCE_ATT_PRIORITY = "priority";
    private static final String SOURCELINE_ELEMENT = "SourceLine";
    private static final String SOURCELINE_ATT_SOURCEPATH = "sourcepath";
    private static final String SOURCELINE_ATT_START = "start";
    private static final String LONGMESSAGE_ELEMENT = "LongMessage";

    SpotbugsParser() {
    }

    @Override
    public Report parse(Document doc) {
        Report report = new Report(StaticCodeAnalysisTool.SPOTBUGS);
        ArrayList<Issue> issues = new ArrayList<Issue>();
        Element root = doc.getRootElement();
        for (Element bugInstance : root.getChildElements(BUGINSTANCE_ELEMENT)) {
            Elements longMessages;
            Issue issue = new Issue();
            issue.setRule(bugInstance.getAttributeValue(BUGINSTANCE_ATT_TYPE));
            issue.setCategory(bugInstance.getAttributeValue(BUGINSTANCE_ATT_CATEGORY));
            issue.setPriority(bugInstance.getAttributeValue(BUGINSTANCE_ATT_PRIORITY));
            Elements sourceLines = bugInstance.getChildElements(SOURCELINE_ELEMENT);
            if (sourceLines.size() > 0) {
                Element sourceLine = sourceLines.get(0);
                String unixPath = ParserUtils.transformToUnixPath(sourceLine.getAttributeValue(SOURCELINE_ATT_SOURCEPATH));
                issue.setFilePath(unixPath);
                int startLine = ParserUtils.extractInt(sourceLine, SOURCELINE_ATT_START);
                issue.setStartLine(startLine);
                issue.setEndLine(startLine);
            }
            if ((longMessages = bugInstance.getChildElements(LONGMESSAGE_ELEMENT)).size() > 0) {
                Element longMessage = longMessages.get(0);
                issue.setMessage(ParserUtils.stripNewLinesAndWhitespace(longMessage.getValue()));
            }
            issues.add(issue);
        }
        report.setIssues(issues);
        return report;
    }
}

