/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.ase.parser.strategy;

import de.tum.in.ase.parser.domain.Issue;
import de.tum.in.ase.parser.domain.Report;
import de.tum.in.ase.parser.strategy.ParserStrategy;
import de.tum.in.ase.parser.strategy.ParserUtils;
import de.tum.in.ase.parser.strategy.StaticCodeAnalysisTool;
import java.util.ArrayList;
import nu.xom.Document;
import nu.xom.Element;

class CheckstyleParser
implements ParserStrategy {
    private static final String FILE_TAG = "file";
    private static final String FILE_ATT_NAME = "name";
    private static final String ERROR_ATT_SOURCE = "source";
    private static final String ERROR_ATT_SEVERITY = "severity";
    private static final String ERROR_ATT_MESSAGE = "message";
    private static final String ERROR_ATT_LINENUMBER = "line";
    private static final String ERROR_ATT_COLUMN = "column";
    private static final String CATEGORY_DELIMITER = "checks";
    private static final String CATEGORY_MISCELLANEOUS = "miscellaneous";

    CheckstyleParser() {
    }

    @Override
    public Report parse(Document doc) {
        Report report = new Report(StaticCodeAnalysisTool.CHECKSTYLE);
        ArrayList<Issue> issues = new ArrayList<Issue>();
        Element root = doc.getRootElement();
        for (Element fileElement : root.getChildElements(FILE_TAG)) {
            String unixPath = ParserUtils.transformToUnixPath(fileElement.getAttributeValue(FILE_ATT_NAME));
            for (Element errorElement : fileElement.getChildElements()) {
                Issue issue = new Issue(unixPath);
                String errorSource = errorElement.getAttributeValue(ERROR_ATT_SOURCE);
                this.extractRuleAndCategory(issue, errorSource);
                issue.setPriority(errorElement.getAttributeValue(ERROR_ATT_SEVERITY));
                issue.setMessage(errorElement.getAttributeValue(ERROR_ATT_MESSAGE));
                int startLine = ParserUtils.extractInt(errorElement, ERROR_ATT_LINENUMBER);
                issue.setStartLine(startLine);
                issue.setEndLine(startLine);
                int startColumn = ParserUtils.extractInt(errorElement, ERROR_ATT_COLUMN);
                issue.setStartColumn(startColumn);
                issue.setEndColumn(startColumn);
                issues.add(issue);
            }
        }
        report.setIssues(issues);
        return report;
    }

    private void extractRuleAndCategory(Issue issue, String errorSource) {
        String[] errorSourceSegments = errorSource.split("\\.");
        int noOfSegments = errorSourceSegments.length;
        if (noOfSegments < 2) {
            issue.setCategory(errorSource);
            return;
        }
        String rule = errorSourceSegments[noOfSegments - 1];
        String category = errorSourceSegments[noOfSegments - 2];
        if (category.equals(CATEGORY_DELIMITER)) {
            category = CATEGORY_MISCELLANEOUS;
        }
        issue.setRule(rule);
        issue.setCategory(category);
    }
}

