/*
 * Decompiled with CFR 0.152.
 */
package de.tud.cs.peaks.sootconfig;

import de.tud.cs.peaks.sootconfig.PhaseOptions;
import de.tud.cs.peaks.sootconfig.PhaseSubOptions;

public class TagAggregatorOptions
extends PhaseOptions {
    private boolean aggregateLineNumbers = false;
    private boolean aggregateArrayBoundsNullChecks = false;
    private boolean aggregateDependenceTags = false;
    private boolean aggregateFieldReadsWrites = false;

    public TagAggregatorOptions() {
        super("tag");
    }

    public TagAggregatorOptions aggregateLineNumber() {
        this.aggregateLineNumbers = true;
        return this;
    }

    public TagAggregatorOptions aggregateArrayBoundsAndNullPointerChecks() {
        this.aggregateArrayBoundsNullChecks = true;
        return this;
    }

    public TagAggregatorOptions aggregateDependenceTags() {
        this.aggregateDependenceTags = true;
        return this;
    }

    public TagAggregatorOptions aggregateFieldReadsWrites() {
        this.aggregateFieldReadsWrites = true;
        return this;
    }

    @Override
    protected void pushToOptionSet() {
        if (this.aggregateLineNumbers) {
            this.pushSubOption(new EnabledSubOption("ln"));
        }
        if (this.aggregateArrayBoundsNullChecks) {
            this.pushSubOption(new EnabledSubOption("an"));
        }
        if (this.aggregateDependenceTags) {
            this.pushSubOption(new EnabledSubOption("dep"));
        }
        if (this.aggregateFieldReadsWrites) {
            this.pushSubOption(new EnabledSubOption("fieldrw"));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagAggregatorOptions that = (TagAggregatorOptions)o;
        if (this.aggregateLineNumbers != that.aggregateLineNumbers) {
            return false;
        }
        if (this.aggregateArrayBoundsNullChecks != that.aggregateArrayBoundsNullChecks) {
            return false;
        }
        if (this.aggregateDependenceTags != that.aggregateDependenceTags) {
            return false;
        }
        return this.aggregateFieldReadsWrites == that.aggregateFieldReadsWrites;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.aggregateLineNumbers ? 1 : 0);
        result = 31 * result + (this.aggregateArrayBoundsNullChecks ? 1 : 0);
        result = 31 * result + (this.aggregateDependenceTags ? 1 : 0);
        result = 31 * result + (this.aggregateFieldReadsWrites ? 1 : 0);
        return result;
    }

    private final class EnabledSubOption
    extends PhaseSubOptions {
        private EnabledSubOption(String name) {
            super(name);
        }

        @Override
        protected void pushToOptionSet() {
            this.addOption("enabled", "true");
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }
}

