/*
 * Decompiled with CFR 0.152.
 */
package de.tud.cs.peaks.sootconfig;

import de.tud.cs.peaks.sootconfig.AnalysisTarget;
import de.tud.cs.peaks.sootconfig.FluentOptions;
import de.tud.cs.peaks.sootconfig.SootResult;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import soot.G;
import soot.PackManager;
import soot.Scene;
import soot.SootMethod;

public class SootRun {
    private final FluentOptions o;
    private final AnalysisTarget t;

    public SootRun(FluentOptions o, AnalysisTarget t) {
        this.o = o;
        this.t = t;
    }

    public SootResult perform() {
        SootResult result = new SootResult();
        result.totalSootRuntime().start();
        ByteArrayOutputStream out = this.configureSoot();
        this.loadClasses(result);
        this.setEntryPoints(result);
        this.runSootPacks(result);
        result.totalSootRuntime().stop();
        result.setCompleteOutput(out.toString());
        result.setSootGloabel(G.v());
        return result;
    }

    private void runSootPacks(SootResult result) {
        result.packRuntime().start();
        PackManager.v().runPacks();
        result.packRuntime().stop();
    }

    private void setEntryPoints(SootResult result) {
        result.entryPointCalculationRuntime().start();
        List<SootMethod> entryPoints = this.t.getEntryPointCalculator().calculateEntryPoints(Scene.v());
        if (entryPoints != null && entryPoints.size() > 0) {
            Scene.v().setEntryPoints(entryPoints);
        }
        result.entryPointCalculationRuntime().stop();
    }

    private void loadClasses(SootResult result) {
        result.classLoadRuntime().start();
        Scene.v().loadNecessaryClasses();
        result.classLoadRuntime().stop();
    }

    private ByteArrayOutputStream configureSoot() {
        G.reset();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        G.v().out = new PrintStream(out);
        this.o.applyTo(G.v().soot_options_Options());
        this.t.applyTo(G.v().soot_options_Options());
        Scene.v().addBasicClass("antlr.ASTNULLType", 1);
        Scene.v().addBasicClass("com.fasterxml.classmate.members.ResolvedField", 1);
        Scene.v().addBasicClass("com.fasterxml.classmate.members.ResolvedMethod", 1);
        return out;
    }
}

