/*
 * Decompiled with CFR 0.152.
 */
package de.tud.cs.peaks.sootconfig;

import de.tud.cs.peaks.sootconfig.PhaseSubOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import soot.options.Options;
import soot.util.ArraySet;

public abstract class PhaseOptions {
    private final String phase;
    private final Map<String, String> options = new HashMap<String, String>();
    private final Set<PhaseSubOptions> subOptions = new ArraySet();

    public PhaseOptions(String phase) {
        this.phase = phase;
    }

    public Options apply(Options o) {
        this.pushToOptionSet();
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            o.setPhaseOption(this.phase, entry.getKey() + ":" + entry.getValue());
        }
        for (PhaseSubOptions pso : this.subOptions) {
            pso.pushToOptionSet();
            for (Map.Entry<String, String> entry : pso.entrySet()) {
                o.setPhaseOption(this.phase + "." + pso.getName(), entry.getKey() + ":" + entry.getValue());
            }
        }
        return o;
    }

    protected void pushSubOption(PhaseSubOptions pso) {
        this.subOptions.add(pso);
    }

    protected abstract void pushToOptionSet();

    protected void addOption(String key, String value) {
        this.options.put(key, value);
    }

    protected void removeOption(String key) {
        this.options.remove(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhaseOptions that = (PhaseOptions)o;
        if (!this.phase.equals(that.phase)) {
            return false;
        }
        if (!this.options.equals(that.options)) {
            return false;
        }
        return this.subOptions.equals(that.subOptions);
    }

    public int hashCode() {
        int result = this.phase.hashCode();
        result = 31 * result + this.options.hashCode();
        result = 31 * result + this.subOptions.hashCode();
        return result;
    }
}

