/*
 * Decompiled with CFR 0.152.
 */
package de.tud.cs.peaks.sootconfig;

import de.tud.cs.peaks.sootconfig.CallGraphAlgorithmMode;
import de.tud.cs.peaks.sootconfig.CallGraphPhaseSubOptions;
import de.tud.cs.peaks.sootconfig.PhaseOptions;

public class CallGraphPhaseOptions
extends PhaseOptions {
    private boolean allReachable = false;
    private CallGraphAlgorithmMode mode = CallGraphAlgorithmMode.Application;

    public CallGraphPhaseOptions() {
        super("cg");
    }

    public CallGraphPhaseOptions processAllReachable() {
        this.allReachable = true;
        return this;
    }

    public CallGraphPhaseOptions processOnlyEntryPoints() {
        this.allReachable = false;
        return this;
    }

    public CallGraphPhaseOptions applicationMode() {
        this.mode = CallGraphAlgorithmMode.Application;
        return this;
    }

    public CallGraphPhaseOptions libraryMode() {
        this.mode = CallGraphAlgorithmMode.Library;
        return this;
    }

    public CallGraphPhaseOptions libraryModeSignatureResolution() {
        this.mode = CallGraphAlgorithmMode.LibraryWithSignatureResolution;
        return this;
    }

    public CallGraphPhaseOptions addSubOption(CallGraphPhaseSubOptions pso) {
        this.pushSubOption(pso);
        return this;
    }

    @Override
    protected void pushToOptionSet() {
        this.addOption("all-reachable", this.allReachable ? "true" : "false");
        switch (this.mode) {
            case Application: {
                this.addOption("library", "disabled");
                break;
            }
            case Library: {
                this.addOption("library", "any-subtype");
                break;
            }
            case LibraryWithSignatureResolution: {
                this.addOption("library", "signature-resolution");
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CallGraphPhaseOptions that = (CallGraphPhaseOptions)o;
        if (this.allReachable != that.allReachable) {
            return false;
        }
        return this.mode == that.mode;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.allReachable ? 1 : 0);
        result = 31 * result + this.mode.hashCode();
        return result;
    }
}

